# app/__init__.py
from flask import Flask, flash, redirect, jsonify, url_for, session
from flask_sqlalchemy import SQLAlchemy
from sqlalchemy.orm import sessionmaker, relationship
from werkzeug.security import generate_password_hash, check_password_hash
from webapp.config import Config
from flask_login import LoginManager,login_user, logout_user, login_required, current_user,UserMixin
from flask_wtf import FlaskForm
from wtforms import StringField, FloatField,DecimalField, SelectField, FileField, SubmitField, TextAreaField, IntegerField, DateField, PasswordField, EmailField
from wtforms.validators import DataRequired, Length
from flask_wtf.file import FileField, FileAllowed
import os
from decimal import *
from datetime import datetime, timedelta
from werkzeug.utils import secure_filename
from flask_cors import CORS
from sqlalchemy import and_, or_
# from flask_mail import Mail, Message
import qrcode
import json
db = SQLAlchemy()

login_manager = LoginManager()



def create_app():
    app = Flask(__name__)
    app.config.from_object(Config)
    db.init_app(app)
    CORS(app)
    # mail = Mail(app)
    login_manager.login_view='auth.login'
    login_manager.init_app(app)

    from webapp.views.auth import auth
    app.register_blueprint(auth)
    from webapp.views.backoffice import backoffice
    app.register_blueprint(backoffice)
    from webapp.views.frontoffice import frontoffice
    app.register_blueprint(frontoffice)

    return app

